/*
 * BenchmarkSubscriber.C
 *
 *  Created on: 09.07.2012
 *      Author: erik
 */


#include <stdint.h>
#include <stdlib.h>

#include <yarp/os/all.h>
#include <yarp/sig/Vector.h>
#include <iostream>

#include "../BenchmarkStats.h"


using namespace yarp::os;
using namespace yarp::sig;

int main(int argc, char *argv[])
{
	// Set up YARP
	Network yarp;

	// Make two ports called /hello/in and /hello/out
	// We'll send "Bottles" (a simple nested list container) between these ports
	BufferedPort<VectorOf<uint8_t> > inPort;
	bool ok = inPort.open("/benchmark/in");
	if (!ok) {
		std::cout << "Usage: BenchmarkPublisher Data_Size_In_KB" << std::endl;
		return 1;
	}

	BenchmarkStats b("Subscriber");
	uint64_t memStart = getMemoryUsage();

	while(true)
	{
		uint64_t memDiff1 = getMemoryUsage() - memStart;
		std::cout << "Subscriber Memory1: " << memDiff1 << std::endl;

		// read the message
		VectorOf<uint8_t> *data = inPort.read(true);
		if (data==NULL) {
			std::cout << "Failed to read message" << std::endl;
			Time::delay(0.1);
			continue;
		}


		uint64_t* t = reinterpret_cast<uint64_t*>(data->getFirst());
		b.toc(*t);

		uint64_t memDiff2 = getMemoryUsage() - memStart;
		std::cout << "Publisher Memory2: " << memDiff2 << std::endl;

	}
	return 0;
}

