/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#include <urbi/uobject.hh>

#include "../../PerfStats.h"


///////////////////////////////////////////////////////////////////////////////


class BenchmarkPublisher : public urbi::UObject
{
public:

	BenchmarkPublisher(const std::string& name) : urbi::UObject(name) {
		UBindFunction(BenchmarkPublisher, init);
		UBindFunction(BenchmarkPublisher, summarize);
		total=0;
		count=0;
	}

	void init(int size)
	{
		UBindVar(BenchmarkPublisher, val);
		// mark it as bypass mode for better performance
		val.setBypass(true);
		USetUpdate(100);

		usleep(2*1000000); // make sure all libs are loaded and mem stats are stable
		memStart = getMemoryUsage();
		std::cout << "Publisher Start1: " << memStart << std::endl;

		std::cout << "Size: " << size << std::endl;
		data.type = urbi::BINARY_UNKNOWN;
		data.common.size = size*1024;
		data.common.data = new char[data.common.size];

	}

	void summarize()
	{
		std::cout << "Publishing Average: " << total/count << std::endl;
	}


	int update()
	{
		//std::cout << "update" << std::endl;
		uint64_t* t = reinterpret_cast<uint64_t*>(data.common.data);
		uint64_t start = getCycleCount();
		*t = start;
		val = data;
		uint64_t d = getCycleCount() - start;
		std::cout << "Publishing took: " << d << std::endl;

		total+=d;
		count++;

		uint64_t memDiff2 = getMemoryUsage() - memStart;
		std::cout << "Publisher Memory2: " << memDiff2 << std::endl;

		return 0;
	}

	urbi::UVar val;
	urbi::UBinary data;

	int count;
	uint64_t total;

	uint64_t memStart;
};
UStart(BenchmarkPublisher);


///////////////////////////////////////////////////////////////////////////////


