/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file RPCHandler.h
 *    Signal handler class for RPC calls.
 *
 * @author Erik Einhorn
 * @date   2010/11/23
 */

#ifndef _MIRA_RPCHANDLER_H_
#define _MIRA_RPCHANDLER_H_

#include <queue>

#include <fw/DispatcherThread.h>
#include <rpc/AbstractRPCHandler.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * RPCHandler implements an AbstractRPCHandler. It can be added to a
 * DispatcherThread as a signal handler to allow handling of RPC calls within
 * the thread of the dispatcher.
 */
class RPCHandler : public AbstractRPCHandler
{
public:

	class InvokerRunnable : public IRunnable
	{
	public:
		InvokerRunnable(RPCHandler* handler, AbstractDeferredInvokerPtr invoker) :
			mHandler(handler), mInvoker(invoker) {}

	protected:
		virtual void run(DispatcherThread* dispatcher);

	private:
		RPCHandler* mHandler;
		AbstractDeferredInvokerPtr mInvoker;
	};
	typedef boost::shared_ptr<InvokerRunnable> InvokerRunnablePtr;

	RPCHandler(DispatcherThread* dispatcher, DiagnosticsModulePtr module = NULL) :
		mDispatcher(dispatcher), mDiagnosticsModule(module) {}

	/// Implemented from AbstractRPCHandler
	virtual void queueRequest(AbstractDeferredInvokerPtr invoker);

	/// Implemented to resolve ambiguity
	virtual boost::thread::id getThreadID() const {
		return mDispatcher->getThreadID();
	}

	DiagnosticsModulePtr getDiagnosticsModule() { return mDiagnosticsModule; }

private:
	DispatcherThread* mDispatcher;
	DiagnosticsModulePtr mDiagnosticsModule;
};

typedef boost::shared_ptr<RPCHandler> RPCHandlerPtr;

//////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
