/*
 * Copyright (C) 2025 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TestUtils.h
 *    Utilities for testing XMLMacros.
 *
 * @author Adrian Kriegel
 * @date   Mon Feb 10 2025
 */

#ifndef _MIRA_XML_MACROS_TEST_UTILS_H_
#define _MIRA_XML_MACROS_TEST_UTILS_H_

#include <string>

#include <xml/XMLDom.h>
#include <xml/XMLDomPreprocessor.h>

#include <boost/test/unit_test.hpp>

namespace mira::xmlmacros {

std::string wrapInRoot(const std::string& xml)
{
	return "<root xmlns:macro=\"http://www.mira-project.org/xmlns:macro\">" + xml + "</root>";
}

std::string removeWhitespace(const std::string& input)
{
	std::string result;
	result.reserve(input.size()); // Optional optimization
	std::copy_if(input.begin(), input.end(), std::back_inserter(result),
	             [](unsigned char c) { return !std::isspace(c); });
	return result;
}

void testEqual(const std::string& xml1, const std::string& xml2, bool wrap = true)
{
	XMLDom dom1;
	dom1.loadFromString(wrap ? wrapInRoot(xml1) : xml1);
	XMLDom dom2;
	dom2.loadFromString(wrap ? wrapInRoot(xml2) : xml2);

	XMLDomPreprocessor preprocessor;
	preprocessor.preprocessXML(dom1);
	preprocessor.preprocessXML(dom2);

	BOOST_CHECK_EQUAL(removeWhitespace(dom1.saveToString()), removeWhitespace(dom2.saveToString()));
}

} // namespace mira::xmlmacros

#endif // _MIRA_XML_MACROS_TEST_UTILS_H_
