/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file HasMemberTest.C
 *    Test cases for HasMember.h.
 *
 * @author Erik Einhorn
 * @date   2010/06/30
 */

#include <boost/test/unit_test.hpp>

#include <iostream>
#include <utils/HasMember.h>

//using namespace mira;
using namespace std;

// KEEP THE FOLLOWING CODE: We might need it some day ...
// taken from: http://www.rsdn.ru/forum/cpp/2759773.1.aspx
//
//namespace details
//{
//   template <typename type>
//   class void_exp_result
//   {};
//
//   template <typename type, typename U>
//   U const& operator,(U const&, void_exp_result<type>);
//
//   template <typename type, typename U>
//   U& operator,(U&, void_exp_result<type>);
//
//   template <typename src_type, typename dest_type>
//   struct clone_constness
//   {
//     typedef dest_type type;
//   };
//
//   template <typename src_type, typename dest_type>
//   struct clone_constness<const src_type, dest_type>
//   {
//     typedef const dest_type type;
//   };
//
//}
//
//template <typename type, typename call_details>
//struct is_call_possible
//{
//private:
//   class yes {};
//   class no { yes m[2]; };
//
//   struct derived : public type
//   {
//     using type::operator();
//     no operator()(...) const;
//   };
//
//   typedef typename details::clone_constness<type, derived>::type derived_type;
//
//   template <typename T, typename due_type>
//   struct return_value_check
//   {
//     static yes deduce(due_type);
//     static no deduce(...);
//     static no deduce(no);
//     static no deduce(details::void_exp_result<type>);
//   };
//
//   template <typename T>
//   struct return_value_check<T, void>
//   {
//     static yes deduce(...);
//     static no deduce(no);
//   };
//
//   template <bool has, typename F>
//   struct impl
//   {
//     static const bool value = false;
//   };
//
//   template <typename arg1, typename r>
//   struct impl<true, r(arg1)>
//   {
//     static const bool value =
//       sizeof(
//            return_value_check<type, r>::deduce(
//             (((derived_type*)0)->operator()(*(arg1*)0), details::void_exp_result<type>())
//                         )
//            ) == sizeof(yes);
//
//   };
//
//   // specializations of impl for 2 args, 3 args,..
//public:
//   static const bool value = impl<has_member<type>::result, call_details>::value;
//
//};

///////////////////////////////////////////////////////////////////////////////

class Class1
{
public:

	Class1(int i) {}

	void foo() {}
	int  bar(int a) { return 0; }

	static int staticMethod(int a) { return 0;}

	int v;
	static int s;
};

class Class2
{
public:

	template<typename T>
	T  bar(T a) { return 0; }

	template<typename T>
	static T staticMethod(T a) { return 0;}
};

template<typename T>
class Class3
{
public:

	T  bar(T a) { return 0; }
	static T staticMethod(T a) { return 0;}

	T v;
	static T s;
};

class DerivedClass1 : public Class1
{
public:
};

class DerivedClass2 : public Class2
{
public:
};

template <typename T>
class DerivedClass3 : public Class3<T>
{
public:
};

MIRA_MEMBER_DETECTOR(foo);
MIRA_MEMBER_DETECTOR(bar);
MIRA_MEMBER_DETECTOR(staticMethod);
MIRA_MEMBER_DETECTOR(v);
MIRA_MEMBER_DETECTOR(w);
MIRA_MEMBER_DETECTOR(s);


#define CHECK(x, val)  BOOST_CHECK_EQUAL((int)(x), val)


template <typename T>
bool testTemplate()
{
	return MIRA_HAS_MEMBER_TEMPLATE(T, foo)::value;
}

BOOST_AUTO_TEST_CASE( HasMemberFunction )
{
	//CHECK(  MIRA_HAS_MEMBER_FUNCTION(DerivedClass1, void, foo, ())::value , 1);

	CHECK(MIRA_HAS_MEMBER(Class1, foo)::value, 1);
	CHECK(MIRA_HAS_MEMBER(Class1, bar)::value, 1);
	CHECK(MIRA_HAS_MEMBER(Class1, staticMethod)::value, 1);
	CHECK(MIRA_HAS_MEMBER(Class1, v)::value, 1);
	CHECK(MIRA_HAS_MEMBER(Class1, w)::value, 0);
	CHECK(MIRA_HAS_MEMBER(Class1, s)::value, 1);

	CHECK(MIRA_HAS_MEMBER(DerivedClass1, foo)::value, 1);
	CHECK(MIRA_HAS_MEMBER(DerivedClass1, bar)::value, 1);
	CHECK(MIRA_HAS_MEMBER(DerivedClass1, staticMethod)::value, 1);
	CHECK(MIRA_HAS_MEMBER(DerivedClass1, v)::value, 1);
	CHECK(MIRA_HAS_MEMBER(DerivedClass1, w)::value, 0);
	CHECK(MIRA_HAS_MEMBER(DerivedClass1, s)::value, 1);


	CHECK(MIRA_HAS_MEMBER(Class2, foo)::value, 0);
	CHECK(MIRA_HAS_MEMBER(Class2, bar)::value, 1);
	CHECK(MIRA_HAS_MEMBER(Class2, staticMethod)::value, 1);
	CHECK(MIRA_HAS_MEMBER(Class2, v)::value, 0);
	CHECK(MIRA_HAS_MEMBER(Class2, w)::value, 0);
	CHECK(MIRA_HAS_MEMBER(Class2, s)::value, 0);

	CHECK(MIRA_HAS_MEMBER(DerivedClass2, foo)::value, 0);
	CHECK(MIRA_HAS_MEMBER(DerivedClass2, bar)::value, 1);
	CHECK(MIRA_HAS_MEMBER(DerivedClass2, staticMethod)::value, 1);
	CHECK(MIRA_HAS_MEMBER(DerivedClass2, v)::value, 0);
	CHECK(MIRA_HAS_MEMBER(DerivedClass2, w)::value, 0);
	CHECK(MIRA_HAS_MEMBER(DerivedClass2, s)::value, 0);

	CHECK(MIRA_HAS_MEMBER(Class3<int>, foo)::value, 0);
	CHECK(MIRA_HAS_MEMBER(Class3<int>, bar)::value, 1);
	CHECK(MIRA_HAS_MEMBER(Class3<int>, staticMethod)::value, 1);
	CHECK(MIRA_HAS_MEMBER(Class3<int>, v)::value, 1);
	CHECK(MIRA_HAS_MEMBER(Class3<int>, w)::value, 0);
	CHECK(MIRA_HAS_MEMBER(Class3<int>, s)::value, 1);

	CHECK(MIRA_HAS_MEMBER(DerivedClass3<int>, foo)::value, 0);
	CHECK(MIRA_HAS_MEMBER(DerivedClass3<int>, bar)::value, 1);
	CHECK(MIRA_HAS_MEMBER(DerivedClass3<int>, staticMethod)::value, 1);
	CHECK(MIRA_HAS_MEMBER(DerivedClass3<int>, v)::value, 1);
	CHECK(MIRA_HAS_MEMBER(DerivedClass3<int>, w)::value, 0);
	CHECK(MIRA_HAS_MEMBER(DerivedClass3<int>, s)::value, 1);


	CHECK(testTemplate<Class1>(), 1);
	CHECK(testTemplate<int>(), 0);

}

