/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file SerializationVectorDefaultTest.C
 *    Test cases for vector.
 *
 * @author Tim Langner
 */


#include <boost/test/unit_test.hpp>
#include <serialization/adapters/std/vector>

#include "CommonTest.h"

using namespace std;
using namespace mira;

struct MyStruct
{
	string name;
	float size;

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("Name", name, "");
		r.member("Size", size, "", 0.1f);
	}
};

//////////////////////////////////////////////////////////////////////////////

struct WithVector
{
	vector<MyStruct> v;

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		r.member("V", v, "");
	}

	void check()
	{
		BOOST_REQUIRE_EQUAL(v.size(), 3);
		BOOST_CHECK_EQUAL(v[0].name, "First");
		BOOST_CHECK_EQUAL(v[0].size, 0.1f);
		BOOST_CHECK_EQUAL(v[1].name, "Second");
		BOOST_CHECK_EQUAL(v[1].size, 0.1f);
		BOOST_CHECK_EQUAL(v[2].name, "Third");
		BOOST_CHECK_EQUAL(v[2].size, 0.1f);
	}
};

//////////////////////////////////////////////////////////////////////////////

BOOST_AUTO_TEST_CASE( TestVectorWithDefaults )
{
	string xml =
			"<Root>"
			"	<Test>"
			"		<V>"
			"			<item><Name>First</Name></item>"
			"			<item><Name>Second</Name></item>"
			"			<item><Name>Third</Name></item>"
			"		</V>"
			"	</Test>"
			"</Root>";
	testXmlFromString<WithVector>(xml);
}
