/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file SerializeMatrixTest.C
 *    test case for matrix serialization
 *
 * @author Erik Einhorn
 * @date   2011/01/16
 */


#include <boost/test/unit_test.hpp>

#include <serialization/Serialization.h>

#include <math/Eigen.h>
#include <boost/type_traits/is_polymorphic.hpp>

using namespace mira;
using namespace std;

BOOST_AUTO_TEST_CASE( TestBinary )
{
	Eigen::Matrix2f m1;
	m1 << 1.f, 2.f, 3.f, 4.f;
	Buffer<uint8> buffer;
	BinaryBufferSerializer s(&buffer);
	s.serialize(m1);

	Eigen::Matrix2f m2;
	BinaryBufferDeserializer d(&buffer);
	d.deserialize(m2);
	BOOST_CHECK(m1==m2);
}

BOOST_AUTO_TEST_CASE( TestXML )
{
	Eigen::Matrix2f m1;
	m1 << 1.f, 2.f, 3.f, 4.f;
	XMLDom xml;
	XMLSerializer s(xml);

	s.serialize("matrix", m1);
	xml.saveToFile("out.xml");

	Eigen::Matrix2f m2;
	XMLDeserializer d(xml.croot());
	d.deserialize("matrix", m2);
	BOOST_CHECK(m1==m2);
}

