/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file TemplateClassTest.C
 *    $Check if the factory is able to handle classes with template parameters.$.
 *
 * @author Ronny Stricker
 * @date   2011/02/25
 */

#ifndef _MIRA_TEMPLATECLASSTEST_C_
#define _MIRA_TEMPLATECLASSTEST_C_

#include <boost/test/unit_test.hpp>

#include <factory/Factory.h>

using namespace std;

namespace nspace {

class ExampleClass {
public:
	int returnValue() const {
		return 1;
	}
};

namespace subspace {

class ExampleClass2 {
public:
	int returnValue() const {
		return 2;
	}
};

class ExampleClass3 {
public:
	int returnValue() const {
		return 2;
	}
};

typedef ExampleClass3 ExampleClass3Type;

}
}

namespace tspace {
namespace sub {

template <class SpecializeClass>
class TemplateClassTest : public mira::Object {
	MIRA_OBJECT(TemplateClassTest<SpecializeClass>)
public:
	int funnyfunc()
	{
		return mMember.returnValue();
	}

protected:
	SpecializeClass mMember;
};

template <class SpecializeClass1, class SpecializeClass2>
class MultiTemplateClassTest : public mira::Object {
	MIRA_OBJECT( MIRA_PPARAM( MultiTemplateClassTest<SpecializeClass1,SpecializeClass2> ) )
public:
	int funnyfunc()
	{
		return mMember.returnValue();
	}

	int funnyfunc2()
	{
		return mMember2.returnValue();
	}

protected:
	SpecializeClass1 mMember;
	SpecializeClass2 mMember2;
};

}

}

MIRA_TEMPLATE_CLASS_REGISTER((tspace)(sub),TemplateClassTest,
		(nspace::ExampleClass)(nspace::subspace::ExampleClass2)(nspace::subspace::ExampleClass3Type),mira::Object)

MIRA_VARTEMPLATE_CLASS_REGISTER((tspace)(sub),MultiTemplateClassTest,2,
		(nspace::ExampleClass,nspace::subspace::ExampleClass2)
		(nspace::subspace::ExampleClass3,nspace::ExampleClass)
		(nspace::subspace::ExampleClass3,nspace::subspace::ExampleClass2)
		,mira::Object)

//
// Check if macros are able to deal with template classes in global namespace
//

template <class SpecializeClass>
class NoNamespaceTest : public mira::Object {
	MIRA_OBJECT(NoNamespaceTest<SpecializeClass>)
public:
	int funnyfunc()
	{
		return mMember.returnValue();
	}

protected:
	SpecializeClass mMember;
};

MIRA_TEMPLATE_CLASS_REGISTER( , NoNamespaceTest,
		(nspace::ExampleClass)(nspace::subspace::ExampleClass2),mira::Object)

namespace mira {

//////////////////////////////////////////////////////////////////////////////

//#############################################################################
//##  TemplateClassTest Test
//#############################################################################

BOOST_AUTO_TEST_CASE( TemplateClassTester )
{
	// the using namespace trick ;-)
	using namespace tspace::sub;
	using namespace nspace;
	using namespace nspace::subspace;

	// check class objects for correct names and identifiers
	BOOST_REQUIRE_EQUAL( TemplateClassTest<ExampleClass>::CLASS().getIdentifier(),
	                     "tspace::sub::TemplateClassTest<nspace::ExampleClass>" );

	BOOST_REQUIRE_EQUAL( TemplateClassTest<ExampleClass>::CLASS().getName(),
	                     "TemplateClassTest<nspace::ExampleClass>" );

	Object* tTemplateClass
		= ClassFactory::newInstance<Object>(
				TemplateClassTest<ExampleClass>::CLASS().getIdentifier() );
	BOOST_REQUIRE( tTemplateClass != NULL );

	TemplateClassTest<ExampleClass>* tClass
		= dynamic_cast< TemplateClassTest<ExampleClass>* >( tTemplateClass );
	BOOST_REQUIRE( tClass != NULL );

	BOOST_REQUIRE_EQUAL( tClass->funnyfunc(), 1 );

	delete tClass;

	BOOST_REQUIRE_EQUAL( TemplateClassTest<ExampleClass2>::CLASS().getIdentifier(),
	                     "tspace::sub::TemplateClassTest<nspace::subspace::ExampleClass2>" );

	Object* tTemplateClass2
			= ClassFactory::newInstance<Object>(
				TemplateClassTest<ExampleClass2>::CLASS().getIdentifier() );
	BOOST_REQUIRE( tTemplateClass2 != NULL );

	TemplateClassTest<ExampleClass2>* tClass2
		= dynamic_cast< TemplateClassTest<ExampleClass2>* >( tTemplateClass2 );
	BOOST_REQUIRE( tClass2 != NULL );

	BOOST_REQUIRE_EQUAL( tClass2->funnyfunc(), 2 );

	delete tClass2;

	tTemplateClass
		= ClassFactory::newInstance<Object>(
				MultiTemplateClassTest<ExampleClass,ExampleClass2>::CLASS().getIdentifier() );
	BOOST_REQUIRE( tTemplateClass != NULL );

	MultiTemplateClassTest<ExampleClass,ExampleClass2>* tClass3
		= dynamic_cast< MultiTemplateClassTest<ExampleClass,ExampleClass2>* >( tTemplateClass );
	BOOST_REQUIRE( tClass3 != NULL );

	BOOST_REQUIRE_EQUAL( tClass3->getClass().getIdentifier(),
	                     "tspace::sub::MultiTemplateClassTest<nspace::ExampleClass,nspace::subspace::ExampleClass2>" );

	delete tClass3;
}

} // namespace

#endif /* _MIRA_TEMPLATECLASSTEST_C_ */

