/*
 * Copyright (C) 2017 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file VariadicMacro.h
 *    Tools for handling variadic macros
 *
 * @author Christof Schröter
 * @date   2017/10/12
 */

#ifndef _MIRA_VARIADICMACRO_H_
#define _MIRA_VARIADICMACRO_H_

#include <boost/version.hpp>

#if BOOST_VERSION >= 104900
#include <boost/preprocessor/variadic/size.hpp>
#endif

///////////////////////////////////////////////////////////////////////////////

#ifdef BOOST_PP_VARIADICS
	#if BOOST_PP_VARIADICS
		#define MIRA_VARIADIC_SIZE BOOST_PP_VARIADIC_SIZE
	#endif
#endif

///////////////////////////////////////////////////////////////////////////////

#ifndef MIRA_VARIADIC_SIZE

	#define GET_0(...) "__________ Error: Variable argument ('...') needs at least one parameter! __________"
	#define GET_1(i1, ...) i1
	#define GET_2(i1, i2, ...) i2
	#define GET_3(i1, i2, i3, ...) i3
	#define GET_4(i1, i2, i3, i4, ...) i4
	#define GET_5(i1, i2, i3, i4, i5, ...) i5
	#define GET_6(i1, i2, i3, i4, i5, i6, ...) i6
	#define GET_7(i1, i2, i3, i4, i5, i6, i7, ...) i7
	#define GET_8(i1, i2, i3, i4, i5, i6, i7, i8, ...) i8
	#define GET_9(i1, i2, i3, i4, i5, i6, i7, i8, i9, ...) i9
	#define GET_10(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, ...) i10
	#define GET_11(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, ...) i11
	#define GET_12(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, ...) i12
	#define GET_13(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, ...) i13
	#define GET_14(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, ...) i14
	#define GET_15(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, ...) i15
	#define GET_16(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, ...) i16
	#define GET_17(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, ...) i17
	#define GET_18(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, ...) i18
	#define GET_19(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, ...) i19
	#define GET_20(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, ...) i20
	#define GET_21(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, ...) i21
	#define GET_22(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, ...) i22
	#define GET_23(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23, ...) i23
	#define GET_24(i1, i2, i3, i4, i5, i6, i7, i8, i9, i10, i11, i12, i13, i14, i15, i16, i17, i18, i19, i20, i21, i22, i23, i24, ...) i24

	#define GET_N(N, ...) GET_##N(__VA_ARGS__)

	#define MIRA_VARIADIC_SIZE(...) GET_N(24, __VA_ARGS__, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0)
#endif

///////////////////////////////////////////////////////////////////////////////

#endif
