/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file PackageFinder.h
 *    Provides methods for finding packages.
 *
 * @author Tim Langner
 * @date   2013/04/29
 */

#ifndef _MIRA_PACKAGEFINDER_H_
#define _MIRA_PACKAGEFINDER_H_

#include <utils/Path.h>
#include <utils/Time.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Finds a package with given name using an internal cache of packages.
 * @throw XInvalidConfig if no such package exists
 * @param[in] package Name of package to find
 * @param[in] maxCacheAge Maximum age of cache. If cache is too old all packages will
 *            be reindexed (To force reindexing set to 0)
 * @return path to package
 */
Path findPackage(const std::string& package,
                                  Duration maxCacheAge = Duration::infinity());

/**
 * Finds all packages using an internal cache of packages.
 * @param[in] maxCacheAge Maximum age of cache. If cache is too old all packages will
 *            be reindexed (To force reindexing set to 0)
 * @return map of package name , path to package pairs
 */
std::map<std::string, Path> findPackages(Duration maxCacheAge = Duration::infinity());

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
