/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file NullClass.h
 *    Provide marker class for marking an invalid "null" class.
 *
 * @author Erik Einhorn
 * @date   2011/07/01
 */

#ifndef _MIRA_NULLCLASS_H_
#define _MIRA_NULLCLASS_H_

#include <factory/Class.h>

namespace mira {

///////////////////////////////////////////////////////////////////////////////

/**
 * Marker class for marking an invalid "null" class.
 * All class methods will raise an exception if they are called. This
 * class can be used only to check if another class is "null".
 *
 * Usage:
 * <code>
 * const Class& c = ... ;
 * if(c == NullClass::null())
 *     ....
 * </code>
 *
 * @ingroup ClassFactoryModule
 */
class NullClass : public Class
{
private:

	NullClass() : Class("mira::NullClass", "NullClass", false) {}

public:

	virtual ~NullClass() {}

public:

	/// Returns the only single existing instance of a NullClass
	static Class& null();

public:

	virtual std::string const& getIdentifier() const;
	virtual std::string const& getName() const;
	virtual int getTypeId() const;
	virtual Typename getTypename() const;
	virtual Object* newInstance() const;
	virtual Object* newInstance( int paramCount, ... ) const;
	virtual Object* newInstance( std::string const& childIdentifier ) const;
	virtual Object* newInstance( std::string const& childIdentifier, int paramCount, ... ) const;
	virtual bool isAbstract() const;

protected:

	virtual Object* newVAInstance( int paramCount, std::va_list ) const;
};

///////////////////////////////////////////////////////////////////////////////

} // namespace

#endif
