/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

#include <math.h>
#include <math/Math.h>
#include <serialization/XMLSerializer.h>

using namespace mira;
using namespace std;


class MyClass
{

public:

	MyClass()
	{
		// set some dummy values
		setAngle(92);
		mValue =101;
		mValue1=10;
		mValue2=34;
	}

	template<typename Reflector>
	void reflect(Reflector& r)
	{
		// a normal member
		r.member("value", mValue, "");


		// a member where the setter is called when new data was
		// deserialized an should be set into the member.
		// When reading the data is read from the member directly.
		r.member("value2", mValue2,
				setter(&MyClass::setValue2, this), "");

		// a member where the setter and the getter is called
		// for serializing and deserializing the data.
		// Here the member does not need to be specified anymore,
		// it is accessed through the getter and setter only
		r.member("angle",
				getter(&MyClass::getAngle, this),
				setter(&MyClass::setAngle, this), "");
	}

	void setValue2(const int &val)
	{
		cout << "setValue2 called with: " << val << endl;
		mValue2 = val;
	}

	float getAngle()
	{
		// convert from rad to deg
		return mAngle * deg180_div_pi<float>();
	}

	void setAngle(const float &val)
	{
		// convert from deg to rad and set the value
		mAngle = val * pi_div_deg180<float>();
		cout << "Setting angle to: " << mAngle << " rad" << endl;
	}


private:

	int   mValue;
	int   mValue1;
	int   mValue2;

	float mAngle;

};

int main()
{
	XMLDom xml;
	XMLSerializer s(xml);

	MyClass c;
	s.serialize("myobject", c);

	xml.saveToFile("gettersetter.xml");


	XMLDom xml2;
	xml2.loadFromFile("gettersetter.xml");
	XMLDeserializer d(xml2.croot());
	MyClass c2;
	d.deserialize("myobject", c2);



	return 0;
}
