/*
 * Copyright (C) 2012 by
 *   MetraLabs GmbH (MLAB), GERMANY
 * and
 *   Neuroinformatics and Cognitive Robotics Labs (NICR) at TU Ilmenau, GERMANY
 * All rights reserved.
 *
 * Contact: info@mira-project.org
 *
 * Commercial Usage:
 *   Licensees holding valid commercial licenses may use this file in
 *   accordance with the commercial license agreement provided with the
 *   software or, alternatively, in accordance with the terms contained in
 *   a written agreement between you and MLAB or NICR.
 *
 * GNU General Public License Usage:
 *   Alternatively, this file may be used under the terms of the GNU
 *   General Public License version 3.0 as published by the Free Software
 *   Foundation and appearing in the file LICENSE.GPL3 included in the
 *   packaging of this file. Please review the following information to
 *   ensure the GNU General Public License version 3.0 requirements will be
 *   met: http://www.gnu.org/copyleft/gpl.html.
 *   Alternatively you may (at your option) use any later version of the GNU
 *   General Public License if such license has been publicly approved by
 *   MLAB and NICR (or its successors, if any).
 *
 * IN NO EVENT SHALL "MLAB" OR "NICR" BE LIABLE TO ANY PARTY FOR DIRECT,
 * INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
 * THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF "MLAB" OR
 * "NICR" HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * "MLAB" AND "NICR" SPECIFICALLY DISCLAIM ANY WARRANTIES, INCLUDING,
 * BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND "MLAB" AND "NICR" HAVE NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
 */

/**
 * @file ImgPainterExample.C
 *    An example that demonstrates the ImgPainter.
 *
 * @author Erik Einhorn
 * @date   2012/08/16
 */

#include <opencv2/highgui/highgui.hpp>

#include <geometry/Point.h>
#include <image/Img.h>
#include <image/ImgPainter.h>

using namespace mira;

///////////////////////////////////////////////////////////////////////////////

int main()
{
	Img8U3 img(640,480);
	img = Color::Black;

	// draw some transparent lines
	for(int y=0;y<200;++y) {
		ImgPainter::drawTransparentLine(img, Point2i(0,y), Point2i(200,y),
		                                Color::Green, y/200.0f);
		ImgPainter::drawTransparentLine(img, Point2i(0,0), Point2i(200,y),
		                                Color::Red, 0.1f);
		ImgPainter::drawTransparentLine(img, Point2i(200,0), Point2i(0,y),
		                                Color::Blue, 0.1f);
	}

	// draw some covariance ellipses

	ImgPainter::drawCovariance(img, Point2i(400,100), 200.0f,0.01f,100.0f, 2.0f, Color::Yellow, 1);
	ImgPainter::drawCovariance(img, Point2i(400,200), 200.0f,0.0f,100.0f, 2.0f, Color::Yellow, 1);
	ImgPainter::drawCovariance(img, Point2i(400,300), 100.0f,0.0f,200.0f, 2.0f, Color::Yellow, 1);
	ImgPainter::drawCovariance(img, Point2i(400,400), 100.0f,50.0f,200.0f, 2.0f, Color::Yellow, 1);

	Eigen::Matrix2f S;
	S << 100.0f,50.0f,
		 50.0f,200.0f;

	for(float s=0; s<4.0f; s+=0.05f)
		ImgPainter::drawCovariance(img, Point2i(320,240), S, s, Color::RGB(1.0f-s*0.25f,1.0f-s*0.25f,0), 2);

	Eigen::Matrix2f Sinv = S.inverse();
 	ImgPainter::drawInvCovariance(img, Point2i(320,240), Sinv,2.0f, Color::Red, 1);


	cv::imshow("test", (cv::Mat&)img);
	cv::waitKey();

	return 0;
}
